/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.nmos6502.commands.ADC;
import emulator.unittest.hardware.nmos6502.commands.CommandTestBase;
import org.junit.Before;
import org.junit.Test;

public class ADCTest
extends CommandTestBase {
    @Before
    public void setUp() {
        this.command = new ADC();
    }

    @Test
    public void testAddAllZero() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 0, 0, 0, 2, 0);
    }

    @Test
    public void testAddWithCarry() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 0, 0, 0, 1);
    }

    @Test
    public void testAddPositive() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 0, 13, 0, 0, 13);
        this.executeAndCheckCommandOnAccu(this.command, 0, 13, 65, 0, 78);
        this.executeAndCheckCommandOnAccu(this.command, 0, 0, 73, 0, 73);
        this.executeAndCheckCommandOnAccu(this.command, 0, 27, 100, 0, 127);
        this.executeAndCheckCommandOnAccu(this.command, 0, 127, 128, 128, 255);
    }

    @Test
    public void testAddNegative() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 0, 128, 127, 128, 255);
        this.executeAndCheckCommandOnAccu(this.command, 0, 250, 6, 3, 0);
        this.executeAndCheckCommandOnAccu(this.command, 0, 255, 1, 3, 0);
        this.executeAndCheckCommandOnAccu(this.command, 1, 254, 255, 129, 254);
        this.executeAndCheckCommandOnAccu(this.command, 0, 255, 255, 129, 254);
        this.executeAndCheckCommandOnAccu(this.command, 1, 128, 127, 3, 0);
    }

    @Test
    public void testAddSignedPositiveOverflow() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 1, 0, 127, 192, 128);
        this.executeAndCheckCommandOnAccu(this.command, 0, 1, 127, 192, 128);
        this.executeAndCheckCommandOnAccu(this.command, 0, 127, 1, 192, 128);
        this.executeAndCheckCommandOnAccu(this.command, 0, 127, 127, 192, 254);
    }

    @Test
    public void testAddSignedNegativeOverflow() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 0, 128, 128, 67, 0);
        this.executeAndCheckCommandOnAccu(this.command, 0, 150, 128, 65, 22);
        this.executeAndCheckCommandOnAccu(this.command, 0, 150, 150, 65, 44);
    }

    @Test
    public void testDecimalModeFromZero() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 8, 0, 0, 10, 0);
        this.executeAndCheckCommandOnAccu(this.command, 9, 0, 0, 8, 1);
    }

    @Test
    public void testDecimalModeOverflowNibbleToEmptyNibble() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 8, 9, 1, 8, 16);
        this.executeAndCheckCommandOnAccu(this.command, 9, 9, 0, 8, 16);
        this.executeAndCheckCommandOnAccu(this.command, 9, 0, 9, 8, 16);
    }

    @Test
    public void testDecimalModeOverflowNibble() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 8, 41, 1, 8, 48);
        this.executeAndCheckCommandOnAccu(this.command, 9, 41, 0, 8, 48);
        this.executeAndCheckCommandOnAccu(this.command, 9, 16, 25, 8, 48);
    }

    @Test
    public void testDecimalModeOverflowOneToCarry() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 8, 153, 1, 11, 0);
        this.executeAndCheckCommandOnAccu(this.command, 9, 153, 0, 11, 0);
        this.executeAndCheckCommandOnAccu(this.command, 9, 48, 105, 11, 0);
    }

    @Test
    public void testDecimalModeOverflowToCarry() throws EmulatorException {
        this.executeAndCheckCommandOnAccu(this.command, 8, 153, 9, 9, 8);
        this.executeAndCheckCommandOnAccu(this.command, 9, 153, 49, 9, 49);
        this.executeAndCheckCommandOnAccu(this.command, 9, 55, 105, 9, 7);
    }
}

